package com.wechat.project.system.controller;

import com.wechat.common.utils.ServletUtils;
import com.wechat.framework.security.LoginUser;
import com.wechat.framework.security.service.SysLoginService;
import com.wechat.framework.security.service.SysPermissionService;
import com.wechat.framework.security.service.TokenService;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.project.system.domain.SysMenu;
import com.wechat.project.system.domain.SysUser;
import com.wechat.project.system.service.ISysMenuService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysLoginController {
   @Autowired
   private SysLoginService loginService;
   @Autowired
   private ISysMenuService menuService;
   @Autowired
   private SysPermissionService permissionService;
   @Autowired
   private TokenService tokenService;

   @PostMapping({"/login"})
   public AjaxResult login(String username, String password, String code, String uuid) {
      AjaxResult ajax = AjaxResult.success();
      String token = this.loginService.login(username, password, code, uuid);
      ajax.put("token", token);
      return ajax;
   }

   @GetMapping({"getInfo"})
   public AjaxResult getInfo() {
      LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
      if (loginUser == null) {
         return AjaxResult.error("登录超时");
      } else {
         SysUser user = loginUser.getUser();
         if (user == null) {
            return AjaxResult.error("登录超时");
         } else {
            Set<String> roles = this.permissionService.getRolePermission(user);
            Set<String> permissions = this.permissionService.getMenuPermission(user);
            AjaxResult ajax = AjaxResult.success();
            ajax.put("user", user);
            ajax.put("roles", roles);
            ajax.put("permissions", permissions);
            return ajax;
         }
      }
   }

   @GetMapping({"getRouters"})
   public AjaxResult getRouters() {
      LoginUser loginUser = this.tokenService.getLoginUser(ServletUtils.getRequest());
      SysUser user = loginUser.getUser();
      List<SysMenu> menus = this.menuService.selectMenuTreeByUserId(user.getUserId());
      return AjaxResult.success(this.menuService.buildMenus(menus));
   }
}
