package com.wechat.project.system.mapper;

import com.wechat.project.system.domain.SysUser;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public interface SysUserMapper {
   List<SysUser> selectUserList(SysUser sysUser);

   SysUser selectUserByUserName(String userName);

   SysUser selectUserById(Long userId);

   int insertUser(SysUser user);

   int updateUser(SysUser user);

   int updateUserAvatar(@Param("userName") String userName, @Param("avatar") String avatar);

   int resetUserPwd(@Param("userName") String userName, @Param("password") String password);

   int deleteUserById(Long userId);

   int deleteUserByIds(Long[] userIds);

   int checkUserNameUnique(String userName);

   SysUser checkPhoneUnique(String phonenumber);

   SysUser checkEmailUnique(String email);

   SysUser getUserinfo(String username, String password);
}
