package com.wechat.project.system.service;

import com.wechat.project.system.domain.SysUser;
import java.util.List;

public interface ISysUserService {
   List<SysUser> selectUserList(SysUser user);

   SysUser selectUserByUserName(String userName);

   SysUser selectUserById(Long userId);

   String selectUserRoleGroup(String userName);

   String selectUserPostGroup(String userName);

   String checkUserNameUnique(String userName);

   String checkPhoneUnique(SysUser user);

   String checkEmailUnique(SysUser user);

   void checkUserAllowed(SysUser user);

   int insertUser(SysUser user);

   int updateUser(SysUser user);

   int updateUserStatus(SysUser user);

   int updateUserProfile(SysUser user);

   boolean updateUserAvatar(String userName, String avatar);

   int resetPwd(SysUser user);

   int resetUserPwd(String userName, String password);

   int deleteUserById(Long userId);

   int deleteUserByIds(Long[] userIds);

   SysUser getUserinfo(String username, String password);
}
