package com.wechat.project.system.service.impl;

import com.wechat.project.system.domain.SysDictData;
import com.wechat.project.system.mapper.SysDictDataMapper;
import com.wechat.project.system.service.ISysDictDataService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysDictDataServiceImpl implements ISysDictDataService {
   @Autowired
   private SysDictDataMapper dictDataMapper;

   @Override
   public List<SysDictData> selectDictDataList(SysDictData dictData) {
      return this.dictDataMapper.selectDictDataList(dictData);
   }

   @Override
   public List<SysDictData> selectDictDataByType(String dictType) {
      return this.dictDataMapper.selectDictDataByType(dictType);
   }

   @Override
   public String selectDictLabel(String dictType, String dictValue) {
      return this.dictDataMapper.selectDictLabel(dictType, dictValue);
   }

   @Override
   public SysDictData selectDictDataById(Long dictCode) {
      return this.dictDataMapper.selectDictDataById(dictCode);
   }

   @Override
   public int deleteDictDataById(Long dictCode) {
      return this.dictDataMapper.deleteDictDataById(dictCode);
   }

   @Override
   public int deleteDictDataByIds(Long[] dictCodes) {
      return this.dictDataMapper.deleteDictDataByIds(dictCodes);
   }

   @Override
   public int insertDictData(SysDictData dictData) {
      return this.dictDataMapper.insertDictData(dictData);
   }

   @Override
   public int updateDictData(SysDictData dictData) {
      return this.dictDataMapper.updateDictData(dictData);
   }
}
