package com.wechat.project.tool.generator.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(
   prefix = "gen"
)
@PropertySource({"classpath:generator.yml"})
public class GenConfig {
   public static String author;
   public static String packageName;
   public static boolean autoRemovePre;
   public static String tablePrefix;

   public static String getAuthor() {
      return author;
   }

   @Value("${author}")
   public void setAuthor(String author) {
      GenConfig.author = author;
   }

   public static String getPackageName() {
      return packageName;
   }

   @Value("${packageName}")
   public void setPackageName(String packageName) {
      GenConfig.packageName = packageName;
   }

   public static boolean getAutoRemovePre() {
      return autoRemovePre;
   }

   @Value("${autoRemovePre}")
   public void setAutoRemovePre(boolean autoRemovePre) {
      GenConfig.autoRemovePre = autoRemovePre;
   }

   public static String getTablePrefix() {
      return tablePrefix;
   }

   @Value("${tablePrefix}")
   public void setTablePrefix(String tablePrefix) {
      GenConfig.tablePrefix = tablePrefix;
   }
}
