package com.wechat;

import com.wechat.framework.config.WeChatOAuthProperties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication(
   exclude = {DataSourceAutoConfiguration.class}
)
@EnableConfigurationProperties({WeChatOAuthProperties.class})
@EnableScheduling
public class WechatApplication {
   public static void main(String[] args) {
      SpringApplication.run(WechatApplication.class, args);
      System.out.println("启动成功");
   }
}
