package com.wechat.common.utils;

import com.wechat.common.exception.CustomException;
import com.wechat.framework.security.LoginUser;
import com.wechat.project.system.domain.SysUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SecurityUtils {
   public static String getUsername() {
      try {
         return getLoginUser().getUsername();
      } catch (Exception var1) {
         throw new CustomException("获取用户账户异常", 401);
      }
   }

   public static String getUsernameDoctorID() {
      try {
         SysUser user = getLoginUser().getUser();
         return user.getDoctorId();
      } catch (Exception var1) {
         throw new CustomException("获取用户账户异常", 401);
      }
   }

   public static LoginUser getLoginUser() {
      try {
         return (LoginUser)getAuthentication().getPrincipal();
      } catch (Exception var1) {
         throw new CustomException("获取用户信息异常", 401);
      }
   }

   public static Authentication getAuthentication() {
      return SecurityContextHolder.getContext().getAuthentication();
   }

   public static String encryptPassword(String password) {
      BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
      return passwordEncoder.encode(password);
   }

   public static boolean matchesPassword(String rawPassword, String encodedPassword) {
      BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
      return passwordEncoder.matches(rawPassword, encodedPassword);
   }

   public static boolean isAdmin(Long userId) {
      return userId != null && 1L == userId;
   }
}
