package com.wechat.common.utils.job;

import com.wechat.common.utils.ExceptionUtil;
import com.wechat.common.utils.StringUtils;
import com.wechat.common.utils.bean.BeanUtils;
import com.wechat.common.utils.spring.SpringUtils;
import com.wechat.project.monitor.domain.SysJob;
import com.wechat.project.monitor.domain.SysJobLog;
import com.wechat.project.monitor.service.ISysJobLogService;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuartzJob implements Job {
   private static final Logger log = LoggerFactory.getLogger(AbstractQuartzJob.class);
   private static ThreadLocal<Date> threadLocal = new ThreadLocal<>();

   public void execute(JobExecutionContext context) throws JobExecutionException {
      SysJob sysJob = new SysJob();
      BeanUtils.copyBeanProp(sysJob, context.getMergedJobDataMap().get("TASK_PROPERTIES"));

      try {
         this.before(context, sysJob);
         if (sysJob != null) {
            this.doExecute(context, sysJob);
         }

         this.after(context, sysJob, null);
      } catch (Exception var4) {
         log.error("任务执行异常  - ：", var4);
         this.after(context, sysJob, var4);
      }
   }

   protected void before(JobExecutionContext context, SysJob sysJob) {
      threadLocal.set(new Date());
   }

   protected void after(JobExecutionContext context, SysJob sysJob, Exception e) {
      Date startTime = threadLocal.get();
      threadLocal.remove();
      SysJobLog sysJobLog = new SysJobLog();
      sysJobLog.setJobName(sysJob.getJobName());
      sysJobLog.setJobGroup(sysJob.getJobGroup());
      sysJobLog.setInvokeTarget(sysJob.getInvokeTarget());
      sysJobLog.setStartTime(startTime);
      sysJobLog.setStopTime(new Date());
      long runMs = sysJobLog.getStopTime().getTime() - sysJobLog.getStartTime().getTime();
      sysJobLog.setJobMessage(sysJobLog.getJobName() + " 总共耗时：" + runMs + "毫秒");
      if (e != null) {
         sysJobLog.setStatus("1");
         String errorMsg = StringUtils.substring(ExceptionUtil.getExceptionMessage(e), 0, 2000);
         sysJobLog.setExceptionInfo(errorMsg);
      } else {
         sysJobLog.setStatus("0");
      }

      SpringUtils.getBean(ISysJobLogService.class).addJobLog(sysJobLog);
   }

   protected abstract void doExecute(JobExecutionContext context, SysJob sysJob) throws Exception;
}
