package com.wechat.common.utils.job;

import java.text.ParseException;
import java.util.Date;
import org.quartz.CronExpression;

public class CronUtils {
   public static boolean isValid(String cronExpression) {
      return CronExpression.isValidExpression(cronExpression);
   }

   public static String getInvalidMessage(String cronExpression) {
      try {
         new CronExpression(cronExpression);
         return null;
      } catch (ParseException var2) {
         return var2.getMessage();
      }
   }

   public static Date getNextExecution(String cronExpression) {
      try {
         CronExpression cron = new CronExpression(cronExpression);
         return cron.getNextValidTimeAfter(new Date(System.currentTimeMillis()));
      } catch (ParseException var2) {
         throw new IllegalArgumentException(var2.getMessage());
      }
   }
}
