package com.wechat.common.utils.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class PropertiesUtil {
   private Properties properties = null;
   private static PropertiesUtil instance = null;
   private static String FILE_PATH = "system.properties";

   public static PropertiesUtil getInstance() {
      if (instance == null) {
         instance = new PropertiesUtil();
      }

      return instance;
   }

   public PropertiesUtil() {
      this.properties = new Properties();

      try {
         InputStreamReader input = new InputStreamReader(PropertiesUtil.class.getClassLoader().getResourceAsStream(FILE_PATH), "UTF-8");
         this.properties.load(input);
         input.close();
      } catch (IOException var2) {
         var2.printStackTrace();
      }
   }

   public Properties getProperties() {
      return this.properties;
   }

   public String get(String key) {
      return this.properties.getProperty(key);
   }

   public String get(String key, String defaultValue) {
      return this.properties.getProperty(key, defaultValue);
   }
}
