package com.wechat.framework.aspectj.lang.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD})
public @interface Excel {
   String name() default "";

   String dateFormat() default "";

   String readConverterExp() default "";

   Excel.ColumnType cellType() default Excel.ColumnType.STRING;

   double height() default 14.0;

   double width() default 16.0;

   String suffix() default "";

   String defaultValue() default "";

   String prompt() default "";

   String[] combo() default {};

   boolean isExport() default true;

   String targetAttr() default "";

   Excel.Type type() default Excel.Type.ALL;

   public static enum ColumnType {
      NUMERIC(0),
      STRING(1);

      private final int value;

      private ColumnType(int value) {
         this.value = value;
      }

      public int value() {
         return this.value;
      }
   }

   public static enum Type {
      ALL(0),
      EXPORT(1),
      IMPORT(2);

      private final int value;

      private Type(int value) {
         this.value = value;
      }

      public int value() {
         return this.value;
      }
   }
}
