package com.wechat.framework.config;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
   @Autowired
   private WechatConfig wechatConfig;

   @Bean
   public Docket createRestApi() {
      return new Docket(DocumentationType.SWAGGER_2)
         .apiInfo(this.apiInfo())
         .select()
         .apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class))
         .paths(PathSelectors.any())
         .build()
         .securitySchemes(this.securitySchemes())
         .securityContexts(this.securityContexts());
   }

   private List<ApiKey> securitySchemes() {
      List<ApiKey> apiKeyList = new ArrayList<>();
      apiKeyList.add(new ApiKey("Authorization", "Authorization", "header"));
      return apiKeyList;
   }

   private List<SecurityContext> securityContexts() {
      List<SecurityContext> securityContexts = new ArrayList<>();
      securityContexts.add(SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex("^(?!auth).*$")).build());
      return securityContexts;
   }

   private List<SecurityReference> defaultAuth() {
      AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
      AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
      List<SecurityReference> securityReferences = new ArrayList<>();
      securityReferences.add(new SecurityReference("Authorization", authorizationScopes));
      return securityReferences;
   }

   private ApiInfo apiInfo() {
      return new ApiInfoBuilder()
         .title("微信公众号后台接口文档（平台、HIS、支付、LIS、PACS、消息推送。。。）")
         .contact(new Contact(this.wechatConfig.getName(), null, null))
         .version("版本号:" + this.wechatConfig.getVersion())
         .build();
   }
}
