package com.wechat.framework.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties("wechatlogin.config")
@Component
public class WeChatOAuthProperties {
   private String appId = "appid";
   private String clientId = "client_id";
   private String secret = "secret";
   private String clientSecret = "client_secret";
   private String state = "state";
   private String wechatRedirect = "wechat_redirect";

   public String getAppId() {
      return this.appId;
   }

   public String getClientId() {
      return this.clientId;
   }

   public String getSecret() {
      return this.secret;
   }

   public String getClientSecret() {
      return this.clientSecret;
   }

   public String getState() {
      return this.state;
   }

   public String getWechatRedirect() {
      return this.wechatRedirect;
   }

   public void setAppId(final String appId) {
      this.appId = appId;
   }

   public void setClientId(final String clientId) {
      this.clientId = clientId;
   }

   public void setSecret(final String secret) {
      this.secret = secret;
   }

   public void setClientSecret(final String clientSecret) {
      this.clientSecret = clientSecret;
   }

   public void setState(final String state) {
      this.state = state;
   }

   public void setWechatRedirect(final String wechatRedirect) {
      this.wechatRedirect = wechatRedirect;
   }

   @Override
   public boolean equals(final Object o) {
      if (o == this) {
         return true;
      } else if (!(o instanceof WeChatOAuthProperties)) {
         return false;
      } else {
         WeChatOAuthProperties other = (WeChatOAuthProperties)o;
         if (!other.canEqual(this)) {
            return false;
         } else {
            Object this$appId = this.getAppId();
            Object other$appId = other.getAppId();
            if (this$appId == null ? other$appId == null : this$appId.equals(other$appId)) {
               Object this$clientId = this.getClientId();
               Object other$clientId = other.getClientId();
               if (this$clientId == null ? other$clientId == null : this$clientId.equals(other$clientId)) {
                  Object this$secret = this.getSecret();
                  Object other$secret = other.getSecret();
                  if (this$secret == null ? other$secret == null : this$secret.equals(other$secret)) {
                     Object this$clientSecret = this.getClientSecret();
                     Object other$clientSecret = other.getClientSecret();
                     if (this$clientSecret == null ? other$clientSecret == null : this$clientSecret.equals(other$clientSecret)) {
                        Object this$state = this.getState();
                        Object other$state = other.getState();
                        if (this$state == null ? other$state == null : this$state.equals(other$state)) {
                           Object this$wechatRedirect = this.getWechatRedirect();
                           Object other$wechatRedirect = other.getWechatRedirect();
                           return this$wechatRedirect == null ? other$wechatRedirect == null : this$wechatRedirect.equals(other$wechatRedirect);
                        } else {
                           return false;
                        }
                     } else {
                        return false;
                     }
                  } else {
                     return false;
                  }
               } else {
                  return false;
               }
            } else {
               return false;
            }
         }
      }
   }

   protected boolean canEqual(final Object other) {
      return other instanceof WeChatOAuthProperties;
   }

   @Override
   public int hashCode() {
      int PRIME = 59;
      int result = 1;
      Object $appId = this.getAppId();
      result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
      Object $clientId = this.getClientId();
      result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
      Object $secret = this.getSecret();
      result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
      Object $clientSecret = this.getClientSecret();
      result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
      Object $state = this.getState();
      result = result * 59 + ($state == null ? 43 : $state.hashCode());
      Object $wechatRedirect = this.getWechatRedirect();
      return result * 59 + ($wechatRedirect == null ? 43 : $wechatRedirect.hashCode());
   }

   @Override
   public String toString() {
      return "WeChatOAuthProperties(appId="
         + this.getAppId()
         + ", clientId="
         + this.getClientId()
         + ", secret="
         + this.getSecret()
         + ", clientSecret="
         + this.getClientSecret()
         + ", state="
         + this.getState()
         + ", wechatRedirect="
         + this.getWechatRedirect()
         + ")";
   }
}
