package com.wechat.framework.config.properties;

import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DruidProperties {
   @Value("${spring.datasource.druid.initialSize}")
   private int initialSize;
   @Value("${spring.datasource.druid.minIdle}")
   private int minIdle;
   @Value("${spring.datasource.druid.maxActive}")
   private int maxActive;
   @Value("${spring.datasource.druid.maxWait}")
   private int maxWait;
   @Value("${spring.datasource.druid.timeBetweenEvictionRunsMillis}")
   private int timeBetweenEvictionRunsMillis;
   @Value("${spring.datasource.druid.minEvictableIdleTimeMillis}")
   private int minEvictableIdleTimeMillis;
   @Value("${spring.datasource.druid.maxEvictableIdleTimeMillis}")
   private int maxEvictableIdleTimeMillis;
   @Value("${spring.datasource.druid.validationQuery}")
   private String validationQuery;
   @Value("${spring.datasource.druid.testWhileIdle}")
   private boolean testWhileIdle;
   @Value("${spring.datasource.druid.testOnBorrow}")
   private boolean testOnBorrow;
   @Value("${spring.datasource.druid.testOnReturn}")
   private boolean testOnReturn;

   public DruidDataSource dataSource(DruidDataSource datasource) {
      datasource.setInitialSize(this.initialSize);
      datasource.setMaxActive(this.maxActive);
      datasource.setMinIdle(this.minIdle);
      datasource.setMaxWait((long)this.maxWait);
      datasource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
      datasource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
      datasource.setMaxEvictableIdleTimeMillis((long)this.maxEvictableIdleTimeMillis);
      datasource.setValidationQuery(this.validationQuery);
      datasource.setTestWhileIdle(this.testWhileIdle);
      datasource.setTestOnBorrow(this.testOnBorrow);
      datasource.setTestOnReturn(this.testOnReturn);
      return datasource;
   }
}
