package com.wechat.framework.datasource;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource extends AbstractRoutingDataSource {
   public DynamicDataSource(DataSource defaultTargetDataSource, Map<Object, Object> targetDataSources) {
      super.setDefaultTargetDataSource(defaultTargetDataSource);
      super.setTargetDataSources(targetDataSources);
      super.afterPropertiesSet();
   }

   protected Object determineCurrentLookupKey() {
      return DynamicDataSourceContextHolder.getDataSourceType();
   }
}
