package com.wechat.framework.redis;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.*;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.Map.Entry;
import java.util.concurrent.TimeUnit;

@Component
public class RedisCache {
   @Autowired
   public RedisTemplate redisTemplate;

   public <T> ValueOperations<String, T> setCacheObject(String key, T value) {
      ValueOperations<String, T> operation = this.redisTemplate.opsForValue();
      operation.set(key, value);
      return operation;
   }

   public <T> ValueOperations<String, T> setCacheObject(String key, T value, Integer timeout, TimeUnit timeUnit) {
      ValueOperations<String, T> operation = this.redisTemplate.opsForValue();
      operation.set(key, value, (long)timeout.intValue(), timeUnit);
      return operation;
   }

   public <T> T getCacheObject(String key) {
      ValueOperations<String, T> operation = this.redisTemplate.opsForValue();
      return (T)operation.get(key);
   }

   public void deleteObject(String key) {
      this.redisTemplate.delete(key);
   }

   public void deleteObject(Collection collection) {
      this.redisTemplate.delete(collection);
   }

   public <T> ListOperations<String, T> setCacheList(String key, List<T> dataList) {
      ListOperations listOperation = this.redisTemplate.opsForList();
      if (null != dataList) {
         int size = dataList.size();

         for (int i = 0; i < size; i++) {
            listOperation.leftPush(key, dataList.get(i));
         }
      }

      return listOperation;
   }

   public <T> List<T> getCacheList(String key) {
      List<T> dataList = new ArrayList<>();
      ListOperations<String, T> listOperation = this.redisTemplate.opsForList();
      Long size = listOperation.size(key);

      for (int i = 0; (long)i < size; i++) {
         dataList.add((T)listOperation.index(key, (long)i));
      }

      return dataList;
   }

   public <T> BoundSetOperations<String, T> setCacheSet(String key, Set<T> dataSet) {
      BoundSetOperations<String, T> setOperation = this.redisTemplate.boundSetOps(key);
      Iterator<T> it = dataSet.iterator();

      while (it.hasNext()) {
         setOperation.add(it.next());
      }

      return setOperation;
   }

   public <T> Set<T> getCacheSet(String key) {
      Set<T> dataSet = new HashSet<>();
      BoundSetOperations<String, T> operation = this.redisTemplate.boundSetOps(key);
      Long size = operation.size();

      for (int i = 0; (long)i < size; i++) {
         dataSet.add((T)operation.pop());
      }

      return dataSet;
   }

   public <T> HashOperations<String, String, T> setCacheMap(String key, Map<String, T> dataMap) {
      HashOperations hashOperations = this.redisTemplate.opsForHash();
      if (null != dataMap) {
         for (Entry<String, T> entry : dataMap.entrySet()) {
            hashOperations.put(key, entry.getKey(), entry.getValue());
         }
      }

      return hashOperations;
   }

   public <T> Map<String, T> getCacheMap(String key) {
      return this.redisTemplate.opsForHash().entries(key);
   }

   public Collection<String> keys(String pattern) {
      return this.redisTemplate.keys(pattern);
   }

   public boolean hasKey(String key) {
      return this.redisTemplate.hasKey(key);
   }

   public long decrKey(String key) {
      return this.redisTemplate.opsForValue().decrement(key, 1L);
   }

   public long incrKey(String key) {
      return this.redisTemplate.opsForValue().increment(key, 1L);
   }
}
