package com.wechat.framework.security.handle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.wechat.framework.security.LoginUser;
import com.wechat.framework.security.service.TokenService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationSuccessHandler implements AuthenticationSuccessHandler {
   @Autowired
   private ObjectMapper objectMapper;
   @Autowired
   private TokenService tokenService;
   private Logger logger = LoggerFactory.getLogger(this.getClass());

   public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
      this.logger.info("登录成功");
      LoginUser loginUser = (LoginUser)authentication.getPrincipal();
      response.setContentType("application/json;charset=UTF-8");
      response.getWriter().write(this.objectMapper.writeValueAsString(this.tokenService.createToken(loginUser)));
   }
}
