package com.wechat.framework.web.controller;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wechat.common.utils.DateUtils;
import com.wechat.common.utils.StringUtils;
import com.wechat.common.utils.sql.SqlUtil;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.PageDomain;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.framework.web.page.TableSupport;
import java.beans.PropertyEditorSupport;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController {
   protected final Logger logger = LoggerFactory.getLogger(BaseController.class);

   @InitBinder
   public void initBinder(WebDataBinder binder) {
      binder.registerCustomEditor(Date.class, new PropertyEditorSupport() {
         @Override
         public void setAsText(String text) {
            this.setValue(DateUtils.parseDate(text));
         }
      });
   }

   protected void startPage() {
      PageDomain pageDomain = TableSupport.buildPageRequest();
      Integer pageNum = pageDomain.getPageNum();
      Integer pageSize = pageDomain.getPageSize();
      System.out.println(pageSize);
      if (StringUtils.isNotNull(pageNum) && StringUtils.isNotNull(pageSize)) {
         String orderBy = SqlUtil.escapeOrderBySql(pageDomain.getOrderBy());
         PageHelper.startPage(pageNum, pageSize, orderBy);
      }
   }

   protected TableDataInfo getDataTable(List<?> list) {
      TableDataInfo rspData = new TableDataInfo();
      if (list == null) {
         rspData.setCode(204);
      } else {
         rspData.setCode(200);
         rspData.setRows(list);
         rspData.setTotal(new PageInfo(list).getTotal());
      }

      return rspData;
   }

   protected AjaxResult toAjax(int rows) {
      return rows > 0 ? AjaxResult.success() : AjaxResult.error();
   }
}
