package com.wechat.project.menutree.controller;

import com.wechat.common.utils.SecurityUtils;
import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.menutree.domain.UserView;
import com.wechat.project.menutree.service.IUserViewService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/mapi/userView"})
public class UserViewController extends BaseController {
   @Autowired
   private IUserViewService userViewService;

   @PreAuthorize("@ss.hasPermi('demo:userView:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(UserView userView) {
      this.startPage();
      List<UserView> list = this.userViewService.selectUserViewList(userView);
      return this.getDataTable(list);
   }

   @Log(
      title = "用户视图关联关系",
      businessType = BusinessType.EXPORT
   )
   @PreAuthorize("@ss.hasPermi('demo:userView:export')")
   @GetMapping({"/export"})
   public AjaxResult export(UserView userView) {
      List<UserView> list = this.userViewService.selectUserViewList(userView);
      ExcelUtil<UserView> util = new ExcelUtil<>(UserView.class);
      return util.exportExcel(list, "用户视图关联关系");
   }

   @PreAuthorize("@ss.hasPermi('demo:userView:query')")
   @GetMapping({"/{id}"})
   public AjaxResult getInfo(@PathVariable Long id) {
      return AjaxResult.success(this.userViewService.selectUserViewById(id));
   }

   @PostMapping
   public AjaxResult add(Long userID, @RequestParam("ids[]") String[] ids) {
      System.out.println(userID);
      System.out.println("传来的是什么鬼");
      return this.toAjax(this.userViewService.insertUserView(userID, ids));
   }

   @PreAuthorize("@ss.hasPermi('demo:userView:edit')")
   @Log(
      title = "用户视图关联关系管理",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@Validated @RequestBody UserView userView) {
      userView.setUpdateBy(SecurityUtils.getUsername());
      return this.toAjax(this.userViewService.updateUserView(userView));
   }

   @PreAuthorize("@ss.hasPermi('demo:userView:remove')")
   @Log(
      title = "用户视图关联关系管理",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{ids}"})
   public AjaxResult remove(@PathVariable Long[] ids) {
      return this.toAjax(this.userViewService.deleteUserViewByIds(ids));
   }

   @GetMapping({"/uid"})
   public AjaxResult getMenuById(Long userId) {
      return AjaxResult.success(this.userViewService.selectUserById(userId));
   }
}
