package com.wechat.project.menutree.controller;

import com.wechat.common.utils.SecurityUtils;
import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.menutree.domain.Menu;
import com.wechat.project.menutree.domain.View;
import com.wechat.project.menutree.service.IViewService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping({"/mapi/menu"})
public class ViewController extends BaseController {
   @Autowired
   private IViewService viewService;

   @GetMapping({"/findMenu"})
   public Map<String, Object> findMenu(String userId) {
      return this.viewService.findMenu(userId);
   }

   @GetMapping({"/menufindOne"})
   public List<Menu> menufindOneById(@RequestParam("name") String name) {
      return "undefined".equals(name) ? null : this.viewService.menufindOne(name);
   }

   @PostMapping({"/menuList"})
   public List<Menu> menuList(@RequestBody Menu menu) {
      if (menu.getStartTime().equals("null") || menu.getEndTime().equals("null")) {
         menu.setStartTime("");
         menu.setEndTime("");
      }

      System.out.println(menu);
      return this.viewService.menuList(menu);
   }

   @PreAuthorize("@ss.hasPermi('demo:view:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(View view) {
      this.startPage();
      List<View> list = this.viewService.selectViewList(view);
      return this.getDataTable(list);
   }

   @Log(
      title = "视图",
      businessType = BusinessType.EXPORT
   )
   @PreAuthorize("@ss.hasPermi('demo:view:export')")
   @GetMapping({"/export"})
   public AjaxResult export(View view) {
      List<View> list = this.viewService.selectViewList(view);
      ExcelUtil<View> util = new ExcelUtil<>(View.class);
      return util.exportExcel(list, "视图");
   }

   @PreAuthorize("@ss.hasPermi('demo:view:query')")
   @GetMapping({"/{id}"})
   public AjaxResult getInfo(@PathVariable Long id) {
      return AjaxResult.success(this.viewService.selectViewById(id));
   }

   @PreAuthorize("@ss.hasPermi('demo:view:add')")
   @Log(
      title = "视图",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@Validated @RequestBody View view) {
      view.setCreateBy(SecurityUtils.getUsername());
      return this.toAjax(this.viewService.insertView(view));
   }

   @PreAuthorize("@ss.hasPermi('demo:view:edit')")
   @Log(
      title = "视图管理",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@Validated @RequestBody View view) {
      view.setUpdateBy(SecurityUtils.getUsername());
      return this.toAjax(this.viewService.updateView(view));
   }

   @PreAuthorize("@ss.hasPermi('demo:view:remove')")
   @Log(
      title = "视图管理",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{ids}"})
   public AjaxResult remove(@PathVariable Long[] ids) {
      return this.toAjax(this.viewService.deleteViewByIds(ids));
   }
}
