package com.wechat.project.menutree.service.impl;

import com.wechat.project.menutree.domain.UserView;
import com.wechat.project.menutree.mapper.UserViewMapper;
import com.wechat.project.menutree.service.IUserViewService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserViewServiceImpl implements IUserViewService {
   @Autowired
   private UserViewMapper userViewMapper;

   @Override
   public List<UserView> selectUserViewList(UserView userView) {
      return this.userViewMapper.selectUserViewList(userView);
   }

   @Override
   public List<UserView> selectUserViewAll() {
      return this.userViewMapper.selectUserViewAll();
   }

   @Override
   public UserView selectUserViewById(Long id) {
      return this.userViewMapper.selectUserViewById(id);
   }

   @Override
   public int deleteUserViewById(Long id) {
      return this.userViewMapper.deleteUserViewById(id);
   }

   @Override
   public int deleteUserViewByIds(Long[] ids) {
      return this.userViewMapper.deleteUserViewByIds(ids);
   }

   @Override
   public int insertUserView(Long userID, String[] ids) {
      int rows = 0;
      this.userViewMapper.deleteMenuByUserId(userID + "");

      for (int i = 0; i < ids.length; i++) {
         UserView um = new UserView();
         um.setUserId(Integer.parseInt(userID + ""));
         um.setViewId(Integer.parseInt(ids[i]));
         rows += this.userViewMapper.insertUserView(um);
      }

      return rows;
   }

   @Override
   public int updateUserView(UserView userView) {
      return this.userViewMapper.updateUserView(userView);
   }

   @Override
   public List<UserView> selectUserById(Long userId) {
      return this.userViewMapper.selectUserById(userId);
   }
}
