package com.wechat.project.system.controller;

import com.wechat.common.utils.SecurityUtils;
import com.wechat.common.utils.poi.ExcelUtil;
import com.wechat.framework.aspectj.lang.annotation.Log;
import com.wechat.framework.aspectj.lang.enums.BusinessType;
import com.wechat.framework.web.controller.BaseController;
import com.wechat.framework.web.domain.AjaxResult;
import com.wechat.framework.web.page.TableDataInfo;
import com.wechat.project.system.domain.SysDictData;
import com.wechat.project.system.service.ISysDictDataService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/system/dict/data"})
public class SysDictDataController extends BaseController {
   @Autowired
   private ISysDictDataService dictDataService;

   @PreAuthorize("@ss.hasPermi('system:dict:list')")
   @GetMapping({"/list"})
   public TableDataInfo list(SysDictData dictData) {
      this.startPage();
      List<SysDictData> list = this.dictDataService.selectDictDataList(dictData);
      return this.getDataTable(list);
   }

   @Log(
      title = "字典数据",
      businessType = BusinessType.EXPORT
   )
   @PreAuthorize("@ss.hasPermi('system:dict:export')")
   @GetMapping({"/export"})
   public AjaxResult export(SysDictData dictData) {
      List<SysDictData> list = this.dictDataService.selectDictDataList(dictData);
      ExcelUtil<SysDictData> util = new ExcelUtil<>(SysDictData.class);
      return util.exportExcel(list, "字典数据");
   }

   @PreAuthorize("@ss.hasPermi('system:dict:query')")
   @GetMapping({"/{dictCode}"})
   public AjaxResult getInfo(@PathVariable Long dictCode) {
      return AjaxResult.success(this.dictDataService.selectDictDataById(dictCode));
   }

   @GetMapping({"/dictType/{dictType}"})
   public AjaxResult dictType(@PathVariable String dictType) {
      return AjaxResult.success(this.dictDataService.selectDictDataByType(dictType));
   }

   @PreAuthorize("@ss.hasPermi('system:dict:add')")
   @Log(
      title = "字典数据",
      businessType = BusinessType.INSERT
   )
   @PostMapping
   public AjaxResult add(@Validated @RequestBody SysDictData dict) {
      dict.setCreateBy(SecurityUtils.getUsername());
      return this.toAjax(this.dictDataService.insertDictData(dict));
   }

   @PreAuthorize("@ss.hasPermi('system:dict:edit')")
   @Log(
      title = "字典数据",
      businessType = BusinessType.UPDATE
   )
   @PutMapping
   public AjaxResult edit(@Validated @RequestBody SysDictData dict) {
      dict.setUpdateBy(SecurityUtils.getUsername());
      return this.toAjax(this.dictDataService.updateDictData(dict));
   }

   @PreAuthorize("@ss.hasPermi('system:dict:remove')")
   @Log(
      title = "字典类型",
      businessType = BusinessType.DELETE
   )
   @DeleteMapping({"/{dictCodes}"})
   public AjaxResult remove(@PathVariable Long[] dictCodes) {
      return this.toAjax(this.dictDataService.deleteDictDataByIds(dictCodes));
   }
}
