package com.wechat.project.system.domain;

import com.wechat.framework.web.domain.BaseEntity;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SysMenu extends BaseEntity {
   private static final long serialVersionUID = 1L;
   private Long menuId;
   private String menuName;
   private String parentName;
   private Long parentId;
   private String orderNum;
   private String path;
   private String component;
   private String isFrame;
   private String menuType;
   private String visible;
   private String perms;
   private String icon;
   private List<SysMenu> children = new ArrayList<>();

   public Long getMenuId() {
      return this.menuId;
   }

   public void setMenuId(Long menuId) {
      this.menuId = menuId;
   }

   @NotBlank(
      message = "菜单名称不能为空"
   )
   @Size(
      min = 0,
      max = 50,
      message = "菜单名称长度不能超过50个字符"
   )
   public String getMenuName() {
      return this.menuName;
   }

   public void setMenuName(String menuName) {
      this.menuName = menuName;
   }

   public String getParentName() {
      return this.parentName;
   }

   public void setParentName(String parentName) {
      this.parentName = parentName;
   }

   public Long getParentId() {
      return this.parentId;
   }

   public void setParentId(Long parentId) {
      this.parentId = parentId;
   }

   @NotBlank(
      message = "显示顺序不能为空"
   )
   public String getOrderNum() {
      return this.orderNum;
   }

   public void setOrderNum(String orderNum) {
      this.orderNum = orderNum;
   }

   @Size(
      min = 0,
      max = 200,
      message = "路由地址不能超过200个字符"
   )
   public String getPath() {
      return this.path;
   }

   public void setPath(String path) {
      this.path = path;
   }

   @Size(
      min = 0,
      max = 200,
      message = "组件路径不能超过255个字符"
   )
   public String getComponent() {
      return this.component;
   }

   public void setComponent(String component) {
      this.component = component;
   }

   public String getIsFrame() {
      return this.isFrame;
   }

   public void setIsFrame(String isFrame) {
      this.isFrame = isFrame;
   }

   @NotBlank(
      message = "菜单类型不能为空"
   )
   public String getMenuType() {
      return this.menuType;
   }

   public void setMenuType(String menuType) {
      this.menuType = menuType;
   }

   public String getVisible() {
      return this.visible;
   }

   public void setVisible(String visible) {
      this.visible = visible;
   }

   @Size(
      min = 0,
      max = 100,
      message = "权限标识长度不能超过100个字符"
   )
   public String getPerms() {
      return this.perms;
   }

   public void setPerms(String perms) {
      this.perms = perms;
   }

   public String getIcon() {
      return this.icon;
   }

   public void setIcon(String icon) {
      this.icon = icon;
   }

   public List<SysMenu> getChildren() {
      return this.children;
   }

   public void setChildren(List<SysMenu> children) {
      this.children = children;
   }

   @Override
   public String toString() {
      return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
         .append("menuId", this.getMenuId())
         .append("menuName", this.getMenuName())
         .append("parentId", this.getParentId())
         .append("orderNum", this.getOrderNum())
         .append("path", this.getPath())
         .append("component", this.getComponent())
         .append("isFrame", this.getIsFrame())
         .append("menuType", this.getMenuType())
         .append("visible", this.getVisible())
         .append("perms", this.getPerms())
         .append("icon", this.getIcon())
         .append("createBy", this.getCreateBy())
         .append("createTime", this.getCreateTime())
         .append("updateBy", this.getUpdateBy())
         .append("updateTime", this.getUpdateTime())
         .append("remark", this.getRemark())
         .toString();
   }
}
