package com.wechat.project.system.mapper;

import com.wechat.project.system.domain.SysMenu;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public interface SysMenuMapper {
   List<SysMenu> selectMenuList(SysMenu menu);

   List<String> selectMenuPerms();

   List<String> selectMenuPermsByUserId(Long userId);

   List<SysMenu> selectMenuTreeAll();

   List<SysMenu> selectMenuTreeByUserId(Long userId);

   List<Integer> selectMenuListByRoleId(Long roleId);

   SysMenu selectMenuById(Long menuId);

   int hasChildByMenuId(Long menuId);

   int insertMenu(SysMenu menu);

   int updateMenu(SysMenu menu);

   int deleteMenuById(Long menuId);

   SysMenu checkMenuNameUnique(@Param("menuName") String menuName, @Param("parentId") Long parentId);
}
