package com.wechat.project.system.service;

import com.wechat.framework.web.domain.TreeSelect;
import com.wechat.project.system.domain.SysMenu;
import com.wechat.project.system.domain.vo.RouterVo;
import java.util.List;
import java.util.Set;

public interface ISysMenuService {
   List<SysMenu> selectMenuList(SysMenu menu);

   Set<String> selectMenuPermsByUserId(Long userId);

   List<SysMenu> selectMenuTreeByUserId(Long userId);

   List<Integer> selectMenuListByRoleId(Long roleId);

   List<RouterVo> buildMenus(List<SysMenu> menus);

   List<SysMenu> buildMenuTree(List<SysMenu> menus);

   List<TreeSelect> buildMenuTreeSelect(List<SysMenu> menus);

   SysMenu selectMenuById(Long menuId);

   boolean hasChildByMenuId(Long menuId);

   boolean checkMenuExistRole(Long menuId);

   int insertMenu(SysMenu menu);

   int updateMenu(SysMenu menu);

   int deleteMenuById(Long menuId);

   String checkMenuNameUnique(SysMenu menu);
}
