package com.wechat.project.system.service.impl;

import com.wechat.common.utils.StringUtils;
import com.wechat.project.system.domain.SysConfig;
import com.wechat.project.system.mapper.SysConfigMapper;
import com.wechat.project.system.service.ISysConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysConfigServiceImpl implements ISysConfigService {
   @Autowired
   private SysConfigMapper configMapper;

   @Override
   public SysConfig selectConfigById(Long configId) {
      SysConfig config = new SysConfig();
      config.setConfigId(configId);
      return this.configMapper.selectConfig(config);
   }

   @Override
   public Object selectConfigByKey(String configKey) {
      SysConfig config = new SysConfig();
      config.setConfigKey(configKey);
      SysConfig retConfig = this.configMapper.selectConfig(config);
      return StringUtils.isNotNull(retConfig) ? retConfig.getConfigValue() : "";
   }

   @Override
   public List<SysConfig> selectConfigList(SysConfig config) {
      return this.configMapper.selectConfigList(config);
   }

   @Override
   public int insertConfig(SysConfig config) {
      return this.configMapper.insertConfig(config);
   }

   @Override
   public int updateConfig(SysConfig config) {
      return this.configMapper.updateConfig(config);
   }

   @Override
   public int deleteConfigById(Long configId) {
      return this.configMapper.deleteConfigById(configId);
   }

   @Override
   public int deleteConfigByIds(Long[] configIds) {
      return this.configMapper.deleteConfigByIds(configIds);
   }

   @Override
   public String checkConfigKeyUnique(SysConfig config) {
      Long configId = StringUtils.isNull(config.getConfigId()) ? -1L : config.getConfigId();
      SysConfig info = this.configMapper.checkConfigKeyUnique(config.getConfigKey());
      return StringUtils.isNotNull(info) && info.getConfigId() != configId ? "1" : "0";
   }
}
