package com.wechat.project.system.service.impl;

import com.wechat.common.utils.SecurityUtils;
import com.wechat.common.utils.StringUtils;
import com.wechat.framework.web.domain.TreeSelect;
import com.wechat.project.system.domain.SysMenu;
import com.wechat.project.system.domain.vo.MetaVo;
import com.wechat.project.system.domain.vo.RouterVo;
import com.wechat.project.system.mapper.SysMenuMapper;
import com.wechat.project.system.mapper.SysRoleMenuMapper;
import com.wechat.project.system.service.ISysMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class SysMenuServiceImpl implements ISysMenuService {
   public static final String PREMISSION_STRING = "perms[\"{0}\"]";
   @Autowired
   private SysMenuMapper menuMapper;
   @Autowired
   private SysRoleMenuMapper roleMenuMapper;

   @Override
   public List<SysMenu> selectMenuList(SysMenu menu) {
      return this.menuMapper.selectMenuList(menu);
   }

   @Override
   public Set<String> selectMenuPermsByUserId(Long userId) {
      List<String> perms = this.menuMapper.selectMenuPermsByUserId(userId);
      Set<String> permsSet = new HashSet<>();

      for (String perm : perms) {
         if (StringUtils.isNotEmpty(perm)) {
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
         }
      }

      return permsSet;
   }

   @Override
   public List<SysMenu> selectMenuTreeByUserId(Long userId) {
      List<SysMenu> menus = null;
      if (SecurityUtils.isAdmin(userId)) {
         menus = this.menuMapper.selectMenuTreeAll();
      } else {
         menus = this.menuMapper.selectMenuTreeByUserId(userId);
      }

      return this.getChildPerms(menus, 0);
   }

   @Override
   public List<Integer> selectMenuListByRoleId(Long roleId) {
      return this.menuMapper.selectMenuListByRoleId(roleId);
   }

   @Override
   public List<RouterVo> buildMenus(List<SysMenu> menus) {
      List<RouterVo> routers = new LinkedList<>();

      for (SysMenu menu : menus) {
         RouterVo router = new RouterVo();
         router.setName(menu.getMenuName());
         router.setPath(this.getRouterPath(menu));
         router.setComponent(StringUtils.isEmpty(menu.getComponent()) ? "Layout" : menu.getComponent());
         router.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon()));
         router.setName(menu.getMenuName());
         List<SysMenu> cMenus = menu.getChildren();
         if (!cMenus.isEmpty() && cMenus.size() > 0 && "M".equals(menu.getMenuType())) {
            router.setAlwaysShow(true);
            router.setRedirect("noRedirect");
            router.setChildren(this.buildMenus(cMenus));
         }

         routers.add(router);
      }

      return routers;
   }

   @Override
   public List<SysMenu> buildMenuTree(List<SysMenu> menus) {
      List<SysMenu> returnList = new ArrayList<>();

      for (SysMenu t : menus) {
         if (t.getParentId() == 0L) {
            this.recursionFn(menus, t);
            returnList.add(t);
         }
      }

      if (returnList.isEmpty()) {
         returnList = menus;
      }

      return returnList;
   }

   @Override
   public List<TreeSelect> buildMenuTreeSelect(List<SysMenu> menus) {
      List<SysMenu> menuTrees = this.buildMenuTree(menus);
      return menuTrees.stream().map(TreeSelect::new).collect(Collectors.toList());
   }

   @Override
   public SysMenu selectMenuById(Long menuId) {
      return this.menuMapper.selectMenuById(menuId);
   }

   @Override
   public boolean hasChildByMenuId(Long menuId) {
      int result = this.menuMapper.hasChildByMenuId(menuId);
      return result > 0;
   }

   @Override
   public boolean checkMenuExistRole(Long menuId) {
      int result = this.roleMenuMapper.checkMenuExistRole(menuId);
      return result > 0;
   }

   @Override
   public int insertMenu(SysMenu menu) {
      return this.menuMapper.insertMenu(menu);
   }

   @Override
   public int updateMenu(SysMenu menu) {
      return this.menuMapper.updateMenu(menu);
   }

   @Override
   public int deleteMenuById(Long menuId) {
      return this.menuMapper.deleteMenuById(menuId);
   }

   @Override
   public String checkMenuNameUnique(SysMenu menu) {
      Long menuId = StringUtils.isNull(menu.getMenuId()) ? -1L : menu.getMenuId();
      SysMenu info = this.menuMapper.checkMenuNameUnique(menu.getMenuName(), menu.getParentId());
      return StringUtils.isNotNull(info) && info.getMenuId() != menuId ? "1" : "0";
   }

   public String getRouterPath(SysMenu menu) {
      String routerPath = menu.getPath();
      if (0L == menu.getParentId() && "1".equals(menu.getIsFrame())) {
         routerPath = "/" + menu.getPath();
      }

      return routerPath;
   }

   public List<SysMenu> getChildPerms(List<SysMenu> list, int parentId) {
      List<SysMenu> returnList = new ArrayList<>();

      for (SysMenu t : list) {
         if (t.getParentId() == (long)parentId) {
            this.recursionFn(list, t);
            returnList.add(t);
         }
      }

      return returnList;
   }

   private void recursionFn(List<SysMenu> list, SysMenu t) {
      List<SysMenu> childList = this.getChildList(list, t);
      t.setChildren(childList);

      for (SysMenu tChild : childList) {
         if (this.hasChild(list, tChild)) {
            for (SysMenu n : childList) {
               this.recursionFn(list, n);
            }
         }
      }
   }

   private List<SysMenu> getChildList(List<SysMenu> list, SysMenu t) {
      List<SysMenu> tlist = new ArrayList<>();

      for (SysMenu n : list) {
         if (Objects.equals(n.getParentId(), t.getMenuId())) {
            tlist.add(n);
         }
      }

      return tlist;
   }

   private boolean hasChild(List<SysMenu> list, SysMenu t) {
      return !this.getChildList(list, t).isEmpty();
   }
}
