package com.wechat.project.system.service.impl;

import com.wechat.common.utils.ServletUtils;
import com.wechat.common.utils.spring.SpringUtils;
import com.wechat.framework.security.LoginUser;
import com.wechat.framework.security.service.TokenService;
import com.wechat.project.system.domain.SysNotice;
import com.wechat.project.system.mapper.SysNoticeMapper;
import com.wechat.project.system.service.ISysNoticeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysNoticeServiceImpl implements ISysNoticeService {
   @Autowired
   private SysNoticeMapper noticeMapper;

   @Override
   public SysNotice selectNoticeById(Long noticeId) {
      return this.noticeMapper.selectNoticeById(noticeId);
   }

   @Override
   public List<SysNotice> selectNoticeList(SysNotice notice) {
      LoginUser currentUser = SpringUtils.getBean(TokenService.class).getLoginUser(ServletUtils.getRequest());
      if (currentUser != null) {
         Long deptid = currentUser.getDeptId();
         notice.setOrgId(deptid);
      }

      return this.noticeMapper.selectNoticeList(notice);
   }

   @Override
   public int insertNotice(SysNotice notice) {
      LoginUser currentUser = SpringUtils.getBean(TokenService.class).getLoginUser(ServletUtils.getRequest());
      if (currentUser != null) {
         Long deptid = currentUser.getDeptId();
         notice.setOrgId(deptid);
      }

      return this.noticeMapper.insertNotice(notice);
   }

   @Override
   public int updateNotice(SysNotice notice) {
      LoginUser currentUser = SpringUtils.getBean(TokenService.class).getLoginUser(ServletUtils.getRequest());
      if (currentUser != null) {
         Long deptid = currentUser.getDeptId();
         notice.setOrgId(deptid);
      }

      return this.noticeMapper.updateNotice(notice);
   }

   @Override
   public int deleteNoticeById(Long noticeId) {
      return this.noticeMapper.deleteNoticeById(noticeId);
   }

   @Override
   public int deleteNoticeByIds(Long noticeIds) {
      return this.noticeMapper.deleteNoticeByIds(noticeIds);
   }
}
