package com.wechat.project.system.service.impl;

import com.wechat.common.utils.StringUtils;
import com.wechat.framework.security.LoginUser;
import com.wechat.project.monitor.domain.SysUserOnline;
import com.wechat.project.system.service.ISysUserOnlineService;
import org.springframework.stereotype.Service;

@Service
public class SysUserOnlineServiceImpl implements ISysUserOnlineService {
   @Override
   public SysUserOnline selectOnlineByIpaddr(String ipaddr, LoginUser user) {
      return StringUtils.equals(ipaddr, user.getIpaddr()) ? this.loginUserToUserOnline(user) : null;
   }

   @Override
   public SysUserOnline selectOnlineByUserName(String userName, LoginUser user) {
      return StringUtils.equals(userName, user.getUsername()) ? this.loginUserToUserOnline(user) : null;
   }

   @Override
   public SysUserOnline selectOnlineByInfo(String ipaddr, String userName, LoginUser user) {
      return StringUtils.equals(ipaddr, user.getIpaddr()) && StringUtils.equals(userName, user.getUsername()) ? this.loginUserToUserOnline(user) : null;
   }

   @Override
   public SysUserOnline loginUserToUserOnline(LoginUser user) {
      if (StringUtils.isNull(user) && StringUtils.isNull(user.getUser())) {
         return null;
      } else {
         SysUserOnline sysUserOnline = new SysUserOnline();
         sysUserOnline.setTokenId(user.getToken());
         sysUserOnline.setUserName(user.getUsername());
         sysUserOnline.setIpaddr(user.getIpaddr());
         sysUserOnline.setLoginLocation(user.getLoginLocation());
         sysUserOnline.setBrowser(user.getBrowser());
         sysUserOnline.setOs(user.getOs());
         sysUserOnline.setLoginTime(user.getLoginTime());
         if (StringUtils.isNotNull(user.getUser().getDept())) {
            sysUserOnline.setDeptName(user.getUser().getDept().getDeptName());
         }

         return sysUserOnline;
      }
   }
}
